/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wile.rsgauges.libmc.detail.SidedProxy;

public class ModResources {
    private static final LinkedList<SoundEvent> created_sounds_ = new LinkedList();
    public static final SoundEvent ALARM_SIREN_SOUND = ModResources.createSoundEvent("alarm_siren_sound");

    private static SoundEvent createSoundEvent(String name) {
        ResourceLocation rl = new ResourceLocation("rsgauges", name);
        SoundEvent se = (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
        created_sounds_.push(se);
        return se;
    }

    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent se : created_sounds_) {
            event.getRegistry().register((IForgeRegistryEntry)se);
        }
    }

    public static final class BlockSoundEvents {
        public static final BlockSoundEvent DEFAULT_SWITCH_MUTE = new BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.0f);
        public static final BlockSoundEvent DEFAULT_SWITCH_ACTIVATION = new BlockSoundEvent(SoundEvents.f_12088_, 0.3f, 0.92f);
        public static final BlockSoundEvent DEFAULT_SWITCH_DEACTIVATION = new BlockSoundEvent(SoundEvents.f_12088_, 0.3f, 0.82f);
        public static final BlockSoundEvent DEFAULT_SWITCH_CONFIGCLICK = new BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f);
        public static final BlockSoundEvent SWITCHLINK_CANNOT_LINK_THAT = new BlockSoundEvent(SoundEvents.f_11850_, 0.2f, 2.5f);
        public static final BlockSoundEvent SWITCHLINK_LINK_TARGET_SELECTED = new BlockSoundEvent(SoundEvents.f_11852_, 0.2f, 2.0f);
        public static final BlockSoundEvent SWITCHLINK_LINK_SOURCE_SELECTED = new BlockSoundEvent(SoundEvents.f_11852_, 0.2f, 2.0f);
        public static final BlockSoundEvent SWITCHLINK_LINK_SOURCE_FAILED = SWITCHLINK_CANNOT_LINK_THAT;
        public static final BlockSoundEvent SWITCHLINK_LINK_PEAL_USE_SUCCESS = new BlockSoundEvent(SoundEvents.f_11899_, 0.1f, 4.0f);
        public static final BlockSoundEvent SWITCHLINK_LINK_PEAL_USE_FAILED = new BlockSoundEvent(SoundEvents.f_11849_, 0.1f, 2.0f);
    }

    public static final class BlockSoundEvent {
        final SoundEvent se_;
        final float volume_;
        final float pitch_;

        public BlockSoundEvent(SoundEvent se, float volume, float pitch) {
            this.se_ = se;
            this.volume_ = volume;
            this.pitch_ = pitch;
        }

        public BlockSoundEvent(SoundEvent se, float volume) {
            this(se, volume, 1.0f);
        }

        public BlockSoundEvent(SoundEvent se) {
            this(se, 1.0f, 1.0f);
        }

        public SoundEvent sound() {
            return this.se_;
        }

        public float volume() {
            return this.volume_;
        }

        public float pitch() {
            return this.pitch_;
        }

        public void play(Level world, BlockPos pos) {
            if (!(world instanceof ServerLevel)) {
                world.m_5594_(SidedProxy.getPlayerClientSide(), pos, this.se_, SoundSource.BLOCKS, this.volume_, this.pitch_);
            } else {
                float volume = Math.min(this.volume_, 1.0f);
                world.m_5594_(null, pos, this.se_, SoundSource.BLOCKS, volume, this.pitch_);
                if (this.volume_ > 1.1f) {
                    for (Direction dir : Direction.values()) {
                        world.m_5594_(null, pos.m_5484_(dir, 15), this.se_, SoundSource.BLOCKS, volume, this.pitch_);
                    }
                }
            }
        }
    }
}

